<?php
/**
 * Command Line Email Test Script
 * Usage: php cli_test.php recipient@example.com
 */

require_once 'send_email.php';

// Check if email argument is provided
if ($argc < 2) {
    echo "Usage: php cli_test.php <recipient_email>\n";
    echo "Example: php cli_test.php test@example.com\n";
    exit(1);
}

$recipientEmail = $argv[1];

// Validate email
if (!filter_var($recipientEmail, FILTER_VALIDATE_EMAIL)) {
    echo "Error: Invalid email address provided.\n";
    exit(1);
}

echo "========================================\n";
echo "SMTP Email Test\n";
echo "========================================\n";
echo "Sending test email to: $recipientEmail\n";
echo "SMTP Host: smtpout.secureserver.net\n";
echo "Port: 465 (SSL)\n";
echo "From: info@dextratechnologies.com\n";
echo "========================================\n\n";

// Send test email
$result = sendTestEmail($recipientEmail);

// Display result
if ($result['status'] === 'success') {
    echo "✓ SUCCESS: " . $result['message'] . "\n";
    exit(0);
} else {
    echo "✗ ERROR: " . $result['message'] . "\n";
    exit(1);
}
